/***********************************************************************
*
Virtual Villagers 3: The Forgotten City
Copyright  2006 - 2008 LDW Software, LLC

Project started September 2007.
Project beta: 
Project completed:  

Built on SDL game engine (MAC) and GapiDraw (PC), using LDW Custom Framework (designed by Arthur Humphrey and Greg Hospelhorn) in Jan/Feb 2006.

Version Notes:
//.3	Base Line VV2 start-point

// 1027 WildTangent

***********************************************************************/
#include "ldwTypes.h"

#if !defined(ISOLA_H_)
#define ISOLA_H_

/***********************************************************************
*
*	Build Settings
*
***********************************************************************/

#define cLdwVersion							1001

#define cDebug								false

#define cReviewCodesEnabled					false

#define cDemo								false

#define cLogging							false

#define cEventsEnabled						true

#define cSplashScreenEnabled				true

#define cSplashScreenDelay					4 //in seconds

#define cTraceOutput						true

const bool cMenuBuyNowButton =              false;

const bool cLaunchOnExitUrl =				false;

#ifndef _MAC
//#define ON_EXIT_URL "steam://store/7310"
#define ON_EXIT_URL "http://www.ldw.com/vv3_win_buy/index.html"
//#define ON_EXIT_URL "http://www.surveymonkey.com/s.asp?u=975873199999"
#endif


#ifdef _MAC
#define ON_EXIT_URL "http://www.ldw.com/vv3_mac_buy/index.html" //put plimus cart here
#endif

/***********************************************************************
 *
 *	Constants 
 *
 ***********************************************************************/
#define numFramesWalkingAnim		8

#define maxNumCollectableTypes	48
#define numberInCollection		12

#define maxNumTotems			50

#define chanceOfTwins			7
#define chanceOfTriplets		25

#define chanceOfBirds			8

//resource offsets
#define bodySetOffset			15
#define headSetOffset			8
#define childSetOffset			8
#define bodyOffsetBetweenDirections	8
#define headOffsetBetweenDirections 1
#define bodyOffsetToBent			10
#define bodyOffsetToSitting			11
#define bodyOffsetToWorking			8

#define numSecondsAutoPause			31000

//#define minutesPerAge				1
#define dailyCheckInterval			360 //in seconds

#define maxOffTime					15  //number of seconds the game can be off or in sleep without adjusting sprite positions, etc

#define maxNumGameStates			99

#define minPredisposedSkillLevel	1	//skill level at which a peep will keep trying to do what they were told

#define baseTechTick				100
#define bonusTechTick				50

#define level1ResearchTick			7
#define level2ResearchTick			1
#define techResearchBonus			2

#define totalResearchPointsToLevel	1000
#define totalResearchPercentDivisor 10  //these two have to work together to make a % complettion. eg: 1000 / 10 = 100; ok!

#define foodConsumptionRate			2 //units per peep per age (approx 10 ages per hour)
#define pregnancyModifier			300 // (ex 300 = .33 chance for master breeder to impregnate)
#define agesUntilAdult				280
#define agesUntilFertile			360
#define agesUntilElderly 			1000
#define greyHairOnsetOffset			100
#define agesOfPregnancy				40
#define agesPerVisibleAge			20
#define agesUntilMortality			1100
#define medicineLongevityBonus		8

#define smallPopulationLimit		10
#define mediumPopulationLimit		17
#define largePopulationLimit		35
//#define absoluteSmallHeapPopLimit	30
#define absolutePopLimit			90

//font and text output
#define widthOfScreen               160
#define avgFloatCharWidth           3.65
#define spaceWidth					5
#define lineSpacing 				8
#define leftMargin					3
//custom window defs
#define widthOfSideFramePiece		2
#define heightOfSideFramePiece		2
#define heightOfTopFramePiece		2
#define heightOfBtmFramePiece		2
#define widthOfTopFramePiece		2

#define maxWidth					154
#define maxHeight					154
#define customWinBackColor          164

//message window
#define msgOKButtonX				108
#define msgOKButtonY				126
#define msgOKButtonWidth			56
#define msgOKButtonHeight			20
// puzzle stat window
#define puzzleOKButtonX				118
#define puzzleOKButtonY				135
#define puzzleOKButtonWidth			28
#define puzzleOKButtonHeight		10
#define stat2PuzzButtonX			88
#define stat2PuzzButtonY			135
#define stat2PuzzButtonWidth		28
#define stat2PuzzButtonHeight		10
#define puzzTextStartY				32
#define puzzDescX					17
#define puzzTimeX					107
#define puzzTitleY					18
#define puzzAchievementX			40
#define puzzHRSX					90
/*
#define statsHoursXPos				17
#define statsHoursYPos				32

*/
//GameEventWindow
#define longButton1X				20
#define longButton1Y				124
#define longButton2X				20
#define longButton2Y				136
#define longButtonWidth				120
#define longButtonHeight			10


//DESCISION MODIFIERS
#define chanceOfNotUsingSkill		15
#define chanceOfNotWorking			15
#define chanceOfIgnoringPredisposition 20
#define motivatorModifier			40
#define chanceOfDoingNothing		65
#define chanceOfBreedingRestraint	75
#define chanceOfCrabs				50

#define chanceOfListeningStory		25

#define chanceOfMatingWhileHungry	65



//offscreen buffer defs
#define offscreenTrim				18

#define widthOfOffScreenWin			200 
#define heightOfOffScreenWin		160	


#define dragBoundryNorth			6
#define dragBoundryWest				3
#define dragBoundryEast				154
#define dragBoundrySouth			110

enum EDirection
{
	eDirection_None = -1,
	eDirection_Random = -2,

	eDirection_Northeast = 0,
	eDirection_Southeast,
	eDirection_Southwest,
	eDirection_Northwest,
	eDirection_North,
	eDirection_East,
	eDirection_South,
	eDirection_West,
	
	eDirection_NumberOf
};



//predisposed behavior enums
#define preNULL						0
//#define preCoconuts					3
#define preResearch					4
#define preFarming					5
//#define preFishing					6
#define preHealing					9
#define preBreeding					10
#define preHut1						11
#define preHut2						12
#define preHut3						13
#define preHospital					14
#define preClothingHut				15
//#define preDam						16
#define preLoveshack				17
//#define preBriar					18
//#define preMosaic					19
//#define preVines					20
#define preHoney					21
#define preBath						22
#define preHarvestFruitTree1		23
#define preHarvestFruitTree2		24
#define preHarvestFruitTree3		25
#define preStatue					26
#define preRuins					27
#define preFishing					28
#define preRosterOfTheDead			29

//int enums for tech types
#define intTechNULL					0
#define intTechFood					1
#define intTechResearch				2
#define intTechConstruction			3
#define intTechSpirituality			4
#define intTechFertility			5
#define intTechMedicine				6

#define messageDuration				5  //...in seconds
#define hotSpotMessageDuration		2

#define maxNumAlertsDef				40

#define tipOffset					1100

#define secondsBetweenAlertsDef		1

#define maxNumItems					20



#define firstCommonChoiceCrisis     104
#define numCommonChoiceCrises		6  // this has to be the number of entries below, up to the last commmon (this is an extremely shitty construct)
#define	gameEventWhale				104

#define	gameEventBerry				105
#define gameEventCrate				106
#define funkyDrumCrisis				107
#define furryFoodCrisis				108
#define theYellowJar				109

#define firstRareChoiceCrisis		132
#define numRareChoiceCrises			4 //this has to be the number of entries below, up to the last rare (this is an extremely shitty construct)
#define theRedPhial					132
#define plantTycoonCrisis			133
#define mysteriousFaceCrisis		134
#define theBluePhial                135

#define firstNoChoiceCrisis			150
#define firstCommonNoChoiceCrisis   151
#define numCommonNoChoiceCrises		5  // this has to be the number of entries below, up to the last commmon (this is an extremely shitty construct)
#define gameCrisisBadMonkey			151
#define gameCrisisGoodMonkey		152
#define gameCrisisStorm				153
#define gameCrisisGreedyMonkey		154
#define berryPlagueCrisis			155


#define firstRareNoChoiceCrisis   	161
#define numRareNoChoiceCrises		3 //this has to be the number of entries below, up to the last rare (this is an extremely shitty construct)
#define anotherShipwreck			161	
#define badAngryMonkey				162	
#define fishOfFertility				163

#define lastNoChoiceCrisis			180
//choice crisis soloutions
#define firstABCrisisResolution		200
#define	gameEventWhaleA				201
#define	gameEventWhaleB				202

#define	gameEventBerryA				203
#define	gameEventBerryB				204

#define	gameEventCrateA				205
#define gameEventCrateB				206

#define plantTycoonCrisisA			207
#define plantTycoonCrisisB			208

#define funkyDrumCrisisA			209
#define funkyDrumCrisisB			210

#define furryFoodCrisisA			211
#define furryFoodCrisisB			212

#define mysteriousFaceCrisisA		213
#define mysteriousFaceCrisisB		214

#define theRedPhialA				215
#define theRedPhialB				216

#define theBluePhialA				217
#define theBluePhialB				218

#define theYellowJarA				219
#define theYellowJarB				220

#define baneContaminatedExpA		221
#define baneContaminatedExpB		222
 

#define lastABCrisisResolution		289
//end choice crisis soln's

#define firstBane					500
#define numBanes					3
#define baneMeasles					500 //sickens or kills children (base + rnd 30%)
#define baneDrought					501 // freeze food production?
#define baneLocusts					502 
//#define baneBarrelOfWoe				503 // mysteriousCrate - random anti food plague/ sickness/ demote peep  @skill level

//#define baneBarrelOfMonkies			506 //destructive bane(ruin buildings/structures)

#define firstBoon					700
#define numBoons					3
#define boonGenius					700 //randomChild gets master researcher
#define boonBerryBees				701
#define boonBarrelOBabies			702
//#define boonDiscovery				701 // + tech points (base + rnd (CorrectForLevel())
//#define boonBarrelOfPlenty			702 // mysterious crate model that yields food bonus's

#define lastBoon					899
#define firstChoiceBane				900
#define numChoiceBanes				1
#define baneContaminatedExp         900

#define firstChoiceBoon				950
#define numChoiceBoons				0

#define messageTerminator			999
//END MESSAGE AND TTIP DEFS

#define tipTextParagraphOffset		0
#define tipDragTrigger				150 //this is mod'd agains the scrolling coord to trigger after dragging a while

#define numSecondsBetweenComments	15

//screen position defines


//STATS DEFS
#define statsHoursXPos				17
#define statsHoursYPos				32 //was 32
#define statsBornXPos				17
#define	statsBornYPos				40 //was 40
#define statsBuriedXPos				17
#define statsBuriedYPos				56 //was 48
#define statsOldestXPos				17
#define statsOldestYPos				64 //was 56
#define statsMaxPopXPos				17
#define statsMaxPopYPos				72 //was 64
#define statsFoodXPos				17
#define statsFoodYPos				80 //was 72
#define statsTechPtsXPos			17
#define statsTechPtsYPos			96 //was 80
#define statsTechLvlXPos			17
#define statsTechLvlYPos			104 //was 88
#define statsNumCrisesXPos			17
#define statsNumCrisesYPos			112 //was 96
#define statsPuzzlesXPos			17
#define statsPuzzlesYPos			120 //was 104
#define statsCuredXPos				17
#define statsCuredYPos				48 //was 112
#define statsCrabsXPos				17
#define statsCrabsYPos				88 //was 120

#define statsHoursValXPos			117
#define statsBornValXPos			117
#define statsBuriedValXPos			117
#define statsOldestValXPos			117
#define statsMaxPopValXPos			117
#define statsFoodValXPos			117
#define statsTotalFoodValXPos       117
#define statsTechPtsValXPos			117
#define statsTechLvlValXPos			117
#define statsNumCrisesValXPos		117
#define statsPuzzlesValXPos			117
#define statsCuredValXPos			117
#define statsCrabsValXPos			117

#define statTickDelay				15
#define statsSnd                    DripSnd

//OVERVIEW MAP defs
#define overviewBlitAreaX			1
#define overviewBlitAreaY			1
#define widthOfOverviewBlitArea		158
#define heightOfOverviewBlitArea	134
//OVERVIEW MAP DECAL DEFS
#define lagoonMiniX					13
#define lagoonMiniY					15
#define idolMiniX					34
#define idolMiniY					43
#define treasureMiniX				100
#define treasureMiniY				120
#define hut1MiniX					80
#define hut1MiniY					83
#define hut2MiniX					22
#define hut2MiniY					72
#define hut3MiniX					22
#define hut3MiniY					93
#define foodMiniX					103
#define foodMiniY					97
#define cropsMini1X					34
#define cropsMini2X					46
#define cropsMini3X					57
#define cropsMiniY					108
#define templeMiniX					125
#define templeMiniY					106
#define gardenMiniX					126
#define gardenMiniY					64
#define caveOpenMiniX				96
#define caveOpenMiniY				0
#define tablewareMiniX				57
#define tablewareMiniY				85



#define mapNorthBoundryDef			1
#define mapSouthBoundryDef			2000
#define mapEastBoundryDef			2000//1540
#define mapWestBoundryDef			1

#define townCenterX					300
#define townCenterY					240
#define mainVillagerNameFieldX		34
#define mainVillagerNameFieldY		118
#define mainVillagerTaskFieldX		34
#define mainVillagerTaskFieldY		140
#define mainVillagerSkillFieldX		34
#define mainVillagerSkillFieldY		129

#define overviewPopFieldX			46
#define overviewPopFieldY			140
#define overviewFoodFieldX			89
#define overviewFoodFieldY			140

#define mainLicenseAreaX			0
#define mainLicenseAreaY			114
//buttons
#define widthOfNavButton			27		
#define heightOfNavButton			9


//about screen

#define aboutLine1Y					17
#define aboutLeftMargin				3
#define aboutLineFeed				6
#define JBotXPos					5
#define	JBotYPos					141


//main village detail license
#define mainVillageFoodFieldX		58
#define mainVillageFoodFieldY		117
#define mainVillagePopFieldX		58
#define mainVillagePopFieldY		128
#define mainVillageDiseaseFieldX	58
#define mainVillageDiseaseFieldY	137

//villager detail screen
#define villagerDoneButtonX			128
#define villagerDoneButtonY			135
#define villagerwidthOfDoneButton	29
#define villagerheightOfDoneButton	10

#define villagerFarmingCheckboxX		146
#define villagerFarmingCheckboxY		74
#define villagerResearchCheckboxX		146
#define villagerResearchCheckboxY		86
#define villagerBreedingCheckboxX		146
#define villagerBreedingCheckboxY		98
#define villagerHealingCheckboxX		146
#define villagerHealingCheckboxY		110
#define villagerConstructionCheckboxX	146
#define villagerConstructionCheckboxY	122
#define villagerWidthOfCheckbox			10
#define villagerHeightOfCheckbox		10

#define villagerLeftArrowButtonX		4
#define villagerLeftArrowButtonY		41
#define villagerRightArrowButtonX		21
#define villagerRightArrowButtonY		41
#define villagerWidthOfLeftRightButton	7
#define villagerHeightOfLeftRightButton	10


//prefs defs

//preference value tokens


#define musicEnabled   			true
#define musicDisabled			false
#define soundEnabled			true
#define soundDisabled			false
#define musicVolLow				0
#define musicVolNorm			1
#define musicVolHi				2
#define difficultyLow			0
#define difficultyNorm			1
#define difficultyHi			2
#define gameSpeedPaused			999
#define gameSpeedSlow			10
#define gameSpeedNorm			6			
#define gameSpeedFast			3


//story2 defs
#define story2YesBtnX		96
#define story2YesBtnY		142
#define story2NoBtnX		126
#define story2NoBtnY		142
#define	story2BtnWidth		28
#define	story2BtnHeight		10

//Stats Defs
#define	statsOKBtnX			118
#define statsOKBtnY			135	
#define statsOKBtnWidth		28
#define statsOKBtnHeight	10


#define puzzleR1			25
#define puzzleR2			57
#define puzzleR3			89		

#define puzzleC1			20
#define puzzleC2			52
#define puzzleC3			84
#define puzzleC4			116

#define puzzleTileWidth		26
#define puzzleTileHeight	26

#define puzzleMsgY			123

#define puzzleEraseX		13
#define puzzleEraseY 		117
#define puzzleEraseWidth	135
#define puzzleEraseHeight	17

// sound manager stuff
//#define soundPlayTime 		6 //in seconds		
#define soundArrayLength    7
//end soundManager stuff

//NEW research Defs
#define noTechFocus					999
#define harvestTechPrices           0
#define buildingTechPrices			1
#define medsTechPrices				2
#define scienceTechPrices			3
#define fertTechPrices				4
#define spiritTechPrices			5

#define harvestPrice2				6000
#define harvestPrice3				50000
#define buildingPrice2				5000
#define buildingPrice3				70000
#define medsPrice2					15000
#define medsPrice3					250000
#define sciencePrice2				12000
#define sciencePrice3				150000
#define fertPrice2					11000
#define fertPrice3					240000
#define spiritPrice2				5000
#define spiritPrice3				80000

#define clothingCost				5000

#define focusXIdx					0
#define focusYIdx					1
#define focusFrame1X				1
#define focusFrame1Y				24
#define focusFrame2X				80 // was 80
#define focusFrame2Y				24
#define focusFrame3X				1
#define focusFrame3Y				61
#define focusFrame4X				80 // was 80
#define focusFrame4Y				61
#define focusFrame5X				1
#define focusFrame5Y				99 //was 98
#define focusFrame6X				80 // was 80
#define focusFrame6Y				99
#define focusFrameWidth				79
#define focusFrameHeight			37

#define researchPointsX				99
#define researchPointsY				15
#define researchDoneButtonX			128
#define researchDoneButtonY			135
#define researchBuyButtonX			100
#define researchBuyButtonY			135
#define researchInfoButtonX         8
#define researchInfoButtonY			135
#define researchWidthOfDoneButton	29
#define researchHeightOfDoneButton	10
#define harvestLine1Y				46
#define harvestLine1AX				5
#define harvestLine1BX				56
#define harvestLine2Y				54
#define harvestLine2AX				5
#define harvestLine2BX				25
#define harvestLine2CX				31
#define harvestLine2DX				37
#define harvestLine2EX				64

#define buildingLine1Y				46
#define buildingLine1AX				83 //add 78 to first column
#define buildingLine1BX				134
#define buildingLine2Y				54
#define buildingLine2AX				83
#define buildingLine2BX				103
#define buildingLine2CX				109
#define buildingLine2DX				115
#define buildingLine2EX				142

#define medicineLine1Y				83
#define medicineLine1AX				5
#define medicineLine1BX				56
#define medicineLine2Y				91
#define medicineLine2AX				5
#define medicineLine2BX				25
#define medicineLine2CX				31
#define medicineLine2DX				37
#define medicineLine2EX 			64

#define scienceLine1Y				83
#define scienceLine1AX				83
#define scienceLine1BX				134
#define scienceLine2Y				91
#define scienceLine2AX				83
#define scienceLine2BX				103
#define scienceLine2CX				109
#define scienceLine2DX				115
#define scienceLine2EX 				142

#define fertilityLine1Y				120
#define fertilityLine1AX			5
#define fertilityLine1BX			56
#define fertilityLine2Y				128
#define fertilityLine2AX			5
#define fertilityLine2BX			25
#define fertilityLine2CX			31
#define fertilityLine2DX			37
#define fertilityLine2EX 			64


#define spiritLine1Y				120
#define spiritLine1AX				83
#define spiritLine1BX				134
#define spiritLine2Y				128
#define spiritLine2AX				83
#define spiritLine2BX				103
#define spiritLine2CX				109
#define spiritLine2DX				115
#define spiritLine2EX 				142

//options
#define optionsNewGameButtonX		35
#define optionsNewGameButtonY		62
#define	optionsContinueButtonX		35
#define optionsContinueButtonY		50
#define optionsRegisterButtonX		35
#define optionsRegisterButtonY		119
#define optionsAboutButtonX			35
#define optionsAboutButtonY			108
#define optionsBeamButtonX			35
#define optionsBeamButtonY			96
#define optionsPrefsButtonX			35
#define optionsPrefsButtonY			73	
#define optionsStatsButtonX			35
#define optionsStatsButtonY			85
#define optionsButtonWidth			68
#define optionsButtonHeight			11
#define optionsContinueDecalX		35
#define optionsContinueDecalY		52
#define optionsRegisterDecalX		34
#define optionsRegisterDecalY		120

// yes/no dialog
#define yesButtonX					52
#define yesButtonY					83
#define noButtonX					82
#define noButtonY					83
#define yesNoButtonWidth			28
#define yesNoButtonHeight			10
#define yesNoPopupWidth				67
#define yesNoPopupHeight			35

//intro2

//main
#define optionsButtonX				131
#define optionsButtonY				136

#define mapButtonX					130
#define mapButtonY					115

#define researchButtonX				130
#define researchButtonY				125

#define villagerDetailButtonX		101
#define villagerDetailButtonY		115

#define maxNameLength				25
//overview
//research
//villager
//stats
//prefs

//end screen position defines

#define redrawInterval				4
#define slowRedrawInterval			20

//peeps defines

#define peepNameSize				30
//skin defs
#define bodyYOffset					5 //(pixels)
#define haloYOffset					17
#define maxNumPSprites				70 //debug this is temp
#define peepSwimmingOffset			12
#define headSittingOffset			5

#define overviewMapOffsetX			175
#define overviewMapOffsetY			41


//end peep defs

//sprites, anim rates
#define minSpriteVel				10
#define maxSpriteVel				75
#define spriteAnimRate				7 //num of iterations to keep a anim cell on sprite
#define headShakeRate				7

#define numBendingFrames			4

//  ARTHUR defines
#define SecondsPerHour				1800//1800  //this is set to real-time 1/2 hours now
#define HoursPerDay					16//12 //this is set to 12 "game hours" per displayed pet age. with 1/2 hours that's 6 hours per day.
#define HoursUntilAdult				144//72
#define HoursUntilElderly			816//336
#define HoursUntilMortal			1152//336
#define MaxHoursOldAge				336//240 //each hour there is a 1 in MaxHoursOldAge - (years of old age) chance of dying, after mortality


enum EWorldState
{
	eBeehiveCleared = 1,
	eAlchemyLabRestored,
	eRainLiftRestored,
	eChiefCreated,
	ePotionsMade,
	eAncientBathsRestored,
	eOrchardStarted,
	eRainDanceMastered,
	eDigRestored,
	ePrincessRestored,
	eSharksCleared,
	eRosterDeadCleared,
	eTreeKeyFound,
	eAshKeyFound,
	eClamKeyFound,
	eSundiskMastered,
	fireStarted,
	clothingHutBuilt,

	hut1Built,
	hut2Built,
	hut3Built,

	coconutsAdded,
	cropsAdded,
	fishAdded,
	crabAdded,
	advanceResearch,
	cemeteryActivated,	//this used for burying dead

	mushroomAdded,
	rareMushroomAdded,

	collectableAdded,

	potFound,
	potBeingRetrieved,

	// End of puzzles
	maxNumPuzzleDefs,

	makeBerries,
	makeCrops,
	makeFood,
	makeDanceparty,
	eating,
	pickingShroom,
	pickingCollectable,
	changingClothes,
	childBoost,
	foodGranted
};

//misc
//#define goldenChildName				199
#define noSpriteInHand 		-99
#define noSpriteInFocus		-99
//#define heldSpritePosition  149
#define firstButterflyIndex	0
#define maxNumButterflies	10
#define firstFloatingAnimIndex		20
#define maxNumFloatingAnimations	30

#define totalFloatingAnimations		50

#define dragSensitivity		3  //how many pixels to drag, to 'grab' a sprite, not just give focus?
// List of key bindings


#define baseLearningRate			33 //beta 4 vv2 was: 30  //percent chance of a complete noob succeeding at a task.

#define chanceOfUsingpreferredSkill  85  //percent
#define chanceOfSkippingProject		 20
#define chanceOfRecuperating		50
#define chanceOfDiseaseDamage		60
#define chanceOfStarvationDamage	75
#define chanceOfRare				50
#define chanceOfChoiceCrisis		50
#define chanceOfNoChoiceCrisis		50
#define chanceOfGoldenChildBirth	10
#define chanceOfElderlyDisease		14 //(once every 12 hours at normal)
#define chanceOfVocationalInjury	2
#define chanceOfFireTechBonus		10
#define chanceOfSpell				30
#define chanceOfBenignSpell			25
#define chanceOfKeepingAtBriars		75

#define chanceOfBoonBane			15

#define healthMercyLevel			20
#define chanceOfMercy				30
#define vocationalMaxDamage			15

#define snapCenterX					795
#define snapCenterY					1500//1122

#define hoursOfFreePlayAloud		48

#define corpseDecayTime				240//DEBUG temp 24 hr...120 ages or 12 real hours
#define	maxNumCharsInMessage		1024
#define messageQueueLength			20

#define coconutsStartingAmount		1500
#define startingFishAmount			1100 //beta 1 700
#define startingCropsAmount			1000 //beta 1 800
#define coconutMinimumHarvestAmount	10

//puzzle completion settings
//#define idolCarvedPoints			1350
//#define rightHutBuiltPoints			250
//#define topLeftHutBuiltPoints		400
//#define bottomLeftHutBuiltPoints	600
#define hut1BuiltPoints				450
#define hut2BuiltPoints				700
#define hut3BuiltPoints				900
#define loveshackBuiltPoints		400
#define hospitalBuiltPoints			1200
#define clothingHutBuiltPoints		400
//#define beachCleanedPoints			150
//#define lagoonClearedPoints			350
//#define gardenRestoredPoints		200
//#define treasureFoundPoints			800
#define magicPlantCompletionPoints  300
//#define wellOpenedPoints			2
//#define templeRebuiltPoints			1000
#define damBuiltPoints				425//dec25 500
#define briarBuiltPoints			3000
#define mosaicBuiltPoints			5000
#define vinesBuiltPoints			1000
#define oceanRestoredPoints			10


#define firstCrisisHours 			1
//debug make these longer duration
#define normalCrisisHours			8

// Note that these two characters are currently virtual, and thus the
// code handling them checks for the command bit in the event record.

#define music1Def					1
#define music2Def					2
#define introMusicDef				3
#define noMusicInstalled			9

//old mystery defs


/***********************************************************************
 *
 *	Internal Structures
 *
 ***********************************************************************/

typedef enum
{
	eGreenCanvas,
	eRedCanvas,
	eOrangeCanvas,
	eNoColor
} DialogColorEnum;	

enum EGameScene
{
	eGameScene_None = -1,

	eGameScene_Main,
	eGameScene_Menu,
	eGameScene_Splash,
	eGameScene_Overview,
	eGameScene_Tech,
	eGameScene_Villager,
	eGameScene_Message,
	eGameScene_UpdatingWorld,
	eGameScene_About,
	eGameScene_PopupYesNo,
	eGameScene_Registration,
	eGameScene_Prefs,
	eGameScene_Stats,
	eGameScene_YesNoDialog,
	eGameScene_Story,
	eGameScene_Progress,
	eGameScene_Collections,
	eGameScene_GameEvent,
	eGameScene_Reg,
	eGameScene_GameWin,
	eGameScene_Loading,
	eGameScene_Help,
	eGameScene_EndGame,

	eGameScene_NumberOf
};	


//END PC MAC FRAMEWORK STRUCTS NEW NEW

typedef struct
	{
	int progress;
	bool completed;
	
	} WorldStateType;

#endif
